#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Eye trapsMod01.fsh   by   Dave Hoskins  
//https://www.shadertoy.com/view/Md2GDy
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.
// David Hoskins.
// https://www.shadertoy.com/view/Md2GDy

float gTime;


vec3 Fractal(vec2 uv)
{
	vec2 p = gTime * ((iResolution.xy-uv)/iResolution.y) - gTime * 0.5 + 0.363 - (smoothstep(0.05, 1.5, gTime)*vec2(.5, .365));
	vec2 z = p;
	float g = 4., f = 4.0;
	for( int i = 0; i < 90; i++ ) 
	{
		float w = float(i)*22.4231+iTime*2.0;
		vec2 z1 = vec2(2.*cos(w),2.*sin(w));		   
		z = vec2( z.x*z.x-z.y*z.y, 2.0 *z.x*z.y ) + p;
		g = min( g, dot(z-z1,z-z1));
		f = min( f, dot(z,z) );
	}
	g =  min(pow(max(1.0-g, 0.0), .15), 1.0);
	// Eye colours...
	vec3 col = mix(vec3(g), vec3(.3, .5, .1), smoothstep(.89, .91, g));
	col = mix(col, vec3(.0), smoothstep(.98, .99, g));
	float c = abs(log(abs(f))/25.0);
	col = mix(col, vec3(f*.03, c*.4, c ), 1.0-g);
	return clamp(col, 0.0, 1.0);
}


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    gTime = pow(abs((.57+cos(iTime*.2)*.55)), 3.0);

    float expand = smoothstep(1.2, 1.6, gTime)*32.0+.5;
	// Anti-aliasing...
	vec3 col = vec3(0.0);
	for (float y = 0.; y < 2.; y++)
	{
		for (float x = 0.; x < 2.; x++)
		{
			col += Fractal(fragCoord.xy + vec2(x, y) * expand);
		}
	}
	
	fragColor = vec4(sqrt(col/4.0), 1.0);

/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

